
<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../db.php';

$site = $_GET['site_id'] ?? null;
if (!$site) { http_response_code(400); echo json_encode(["error"=>"missing site_id"]); exit; }

$sqls = [
  "ac" => "SELECT * FROM ac_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1",
  "generator" => "SELECT * FROM gen_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1",
  "dc" => "SELECT * FROM dc_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1",
  "battery" => "SELECT * FROM battery_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1",
  "solar" => "SELECT * FROM solar_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1",
  "shelter" => "SELECT * FROM shelter_telemetry WHERE site_id=? ORDER BY ts DESC LIMIT 1"
];
$out = [];
foreach ($sqls as $key => $q) {
  $stmt = db()->prepare($q);
  $stmt->execute([$site]);
  $out[$key] = $stmt->fetch();
}
echo json_encode($out);
