
<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../db.php';

// Set a strong secret and keep it private!
const INGEST_TOKEN = 'CHANGE_ME';

$action = $_GET['action'] ?? null;
if ($action === 'init') {
  ensure_schema();
  echo json_encode(["ok"=>true, "message"=>"schema ensured"]);
  exit;
}

$method = $_SERVER['REQUEST_METHOD'];
if ($method !== 'POST') {
  http_response_code(405);
  echo json_encode(["error"=>"POST required"]);
  exit;
}

$token = $_SERVER['HTTP_X_INGEST_TOKEN'] ?? '';
if ($token !== INGEST_TOKEN) {
  http_response_code(401);
  echo json_encode(["error"=>"unauthorized"]);
  exit;
}

$site = $_GET['site_id'] ?? null;
$stream = $_GET['stream'] ?? null;
if (!$site || !$stream) {
  http_response_code(400);
  echo json_encode(["error"=>"missing site_id or stream"]);
  exit;
}

$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
if (!$payload) {
  http_response_code(400);
  echo json_encode(["error"=>"invalid JSON"]);
  exit;
}

// ensure site exists
$stmt = db()->prepare("INSERT IGNORE INTO sites(id) VALUES (?)");
$stmt->execute([$site]);

function iso_to_mysql($iso) {
  $dt = new DateTime($iso);
  return $dt->format('Y-m-d H:i:s');
}

$ts = $payload['ts'] ?? null;
if (!$ts) {
  http_response_code(400);
  echo json_encode(["error"=>"missing ts"]);
  exit;
}
$ts_mysql = iso_to_mysql($ts);
$props = $payload;
unset($props['ts']); // keep extras

switch ($stream) {
  case 'ac':
    $sql = "INSERT INTO ac_telemetry (site_id, ts, grid_status, v_l1, v_l2, v_l3, i_l1, i_l2, i_l3, freq_hz, power_kw, energy_kwh_month, props)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql,
      $payload['grid_status'] ?? null,
      $payload['voltage_v']['L1'] ?? null, $payload['voltage_v']['L2'] ?? null, $payload['voltage_v']['L3'] ?? null,
      $payload['current_a']['L1'] ?? null, $payload['current_a']['L2'] ?? null, $payload['current_a']['L3'] ?? null,
      $payload['frequency_hz'] ?? null,
      $payload['power_kw'] ?? null,
      $payload['energy_kwh_month'] ?? null,
      json_encode($props)
    ];
    break;
  case 'generator':
    $sql = "INSERT INTO gen_telemetry (site_id, ts, status, mode, fuel_level_pct, engine_hours, v_l1, v_l2, v_l3, i_l1, i_l2, i_l3, load_pct, alarms, props)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,CAST(? AS JSON),CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql,
      $payload['status'] ?? null, $payload['mode'] ?? null, $payload['fuel_level_pct'] ?? null, $payload['engine_hours'] ?? null,
      $payload['voltage_v']['L1'] ?? null, $payload['voltage_v']['L2'] ?? null, $payload['voltage_v']['L3'] ?? null,
      $payload['current_a']['L1'] ?? null, $payload['current_a']['L2'] ?? null, $payload['current_a']['L3'] ?? null,
      $payload['load_pct'] ?? null,
      json_encode($payload['alarms'] ?? []),
      json_encode($props)
    ];
    break;
  case 'dc':
    $sql = "INSERT INTO dc_telemetry (site_id, ts, voltage_v, current_a, props)
            VALUES (?,?,?,?,CAST(? AS JSON))";
    $vals = [$site, $ts_mysql, $payload['voltage_v'] ?? null, $payload['current_a'] ?? null, json_encode($props)];
    break;
  case 'battery':
    $sql = "INSERT INTO battery_telemetry (site_id, ts, soc_pct, soh_pct, voltage_v, current_a, temp_c, props)
            VALUES (?,?,?,?,?,?,?,CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql,
      $payload['soc_pct'] ?? null, $payload['soh_pct'] ?? null, $payload['voltage_v'] ?? null,
      $payload['current_a'] ?? null, $payload['temp_c'] ?? null, json_encode($props)
    ];
    break;
  case 'solar':
    $sql = "INSERT INTO solar_telemetry (site_id, ts, voltage_v, current_a, power_kw, energy_kwh_day, energy_kwh_month, props)
            VALUES (?,?,?,?,?,?,?,CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql,
      $payload['voltage_v'] ?? null, $payload['current_a'] ?? null,
      $payload['power_kw'] ?? null, $payload['energy_kwh_day'] ?? null, $payload['energy_kwh_month'] ?? null,
      json_encode($props)
    ];
    break;
  case 'shelter':
    $sql = "INSERT INTO shelter_telemetry (site_id, ts, room_temp_c, door, aircon_status, gps_lat, gps_lng, props)
            VALUES (?,?,?,?,?,?,?,CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql, $payload['room_temp_c'] ?? null, $payload['door'] ?? null, $payload['aircon_status'] ?? null,
      $payload.get('gps',{}).get('lat') if False else None, # placeholder; PHP handling below
      None,
      json_encode($props)
    ];
    // PHP can't use Python-style; fix below with native
    $gps_lat = isset($payload['gps']['lat']) ? $payload['gps']['lat'] : null;
    $gps_lng = isset($payload['gps']['lng']) ? $payload['gps']['lng'] : null;
    $vals[5] = $gps_lat;
    $vals[6] = $gps_lng;
    break;
  case 'event':
    $sql = "INSERT INTO events (site_id, ts, severity, code, message, value, props)
            VALUES (?,?,?,?,?,?,CAST(? AS JSON))";
    $vals = [
      $site, $ts_mysql,
      $payload['severity'] ?? null, $payload['code'] ?? null,
      $payload['message'] ?? null, $payload['value'] ?? null, json_encode($props)
    ];
    break;
  default:
    http_response_code(400);
    echo json_encode(["error"=>"unknown stream"]);
    exit;
}

$stmt = db()->prepare($sql);
$stmt->execute($vals);

echo json_encode(["ok"=>true]);
