
# Cabropex Tower Monitor (cPanel Edition)

A lightweight PHP + MySQL app you can upload to **cPanel** (no Docker required).  
It provides:
- Ingestion endpoint (HTTP POST) to store telemetry
- Dashboard web UI with live status & charts (Chart.js)
- History API for charts

## 1) Create a MySQL DB in cPanel
- cPanel → **MySQL® Databases** → create DB, user, password.
- Add user to DB with **ALL PRIVILEGES**.
- Copy the generated **hostname**, **db name**, **username**, **password**.

## 2) Upload files
- cPanel → **File Manager** → upload the contents of this ZIP into a folder, e.g., `/public_html/monitor`.
- (Optional) Create a subdomain `monitor.cabropex.ke` and map it to that folder.

## 3) Configure DB
- Edit `db.php` and set `$DB_HOST`, `$DB_NAME`, `$DB_USER`, `$DB_PASS`.
- Visit `https://yourdomain/monitor/api/ingest.php?action=init` once to auto-create tables.
  - You'll see `{"ok":true,"message":"schema ensured"}` on success.

## 4) Security token
- Open `api/ingest.php` and set `INGEST_TOKEN` to a strong secret.
- Devices must send header: `X-Ingest-Token: <your secret>`.
- For testing, see the curl examples below.

## 5) Test with curl
Replace `SITE_ID` with `site001`:

```
curl -X POST 'https://yourdomain/monitor/api/ingest.php?site_id=SITE_ID&stream=ac'   -H 'Content-Type: application/json'   -H 'X-Ingest-Token: CHANGE_ME'   -d '{ "ts":"2025-01-01T00:00:00Z","grid_status":"ON",
        "voltage_v":{"L1":231,"L2":232,"L3":230},
        "current_a":{"L1":3,"L2":3,"L3":3},
        "frequency_hz":50,"power_kw":1.95,"energy_kwh_month":10.2 }'
```

Open the dashboard:
```
https://yourdomain/monitor/public/
```

## 6) Sending other streams
- `generator`, `dc`, `battery`, `solar`, `shelter`, `event`
- Endpoint: `POST /api/ingest.php?site_id=SITE_ID&stream=STREAM`

## 7) Runtime edits
Thresholds & reporting intervals can be stored in `site_settings` table and edited later via SQL or small admin endpoints (not included in this starter for brevity).

